@echo off
echo Installing Scraper AI Certificate...
echo.
echo Please click "Yes" on the User Account Control (UAC) prompt to allow the certificate installation.
echo.

:: Check for Administrator privileges
net session >nul 2>&1
if %errorLevel% == 0 (
    goto :admin
) else (
    echo Requesting administrative privileges...
    powershell -Command "Start-Process '%~0' -Verb RunAs"
    exit /b
)

:admin
:: Push to the directory of the script
pushd "%~dp0"

:: Add the certificate to the Trusted Root Certification Authorities store
certutil -addstore "Root" "certificate.cer"

if %errorLevel% == 0 (
    echo.
    echo ========================================================
    echo   SUCCESS! Certificate installed.
    echo   You can now install Scraper AI.
    echo ========================================================
) else (
    echo.
    echo ========================================================
    echo   ERROR: Failed to install certificate.
    echo ========================================================
)

pause
popd
